/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.block;

import azmalent.terraincognita.common.tile.BasketTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BasketBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE = BasketBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);

    public BasketBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(0.6f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean waterlogged = fluidState.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BasketTileEntity) {
            BasketTileEntity basket = (BasketTileEntity)te;
            player.func_213829_a((INamedContainerProvider)basket);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BasketTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BasketTileEntity) {
            BasketTileEntity basket = (BasketTileEntity)te;
            basket.readFromStack(stack);
            if (stack.func_82837_s()) {
                basket.setCustomName(stack.func_200301_q());
            }
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            if (world.func_175625_s(pos) instanceof BasketTileEntity) {
                world.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public void func_176208_a(World world, @Nonnull BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof BasketTileEntity) {
            BasketTileEntity basket = (BasketTileEntity)te;
            if (!player.func_184812_l_() || !basket.func_191420_l()) {
                ItemStack stack = basket.saveToStack();
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                itemEntity.func_174869_p();
                world.func_217376_c((Entity)itemEntity);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }
}

